package jamezo97.clonecraft.recipe;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.dna.ItemData;

import java.util.ArrayList;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeGeneDNA implements IRecipe, IOnCrafted{
	
	public RecipeGeneDNA(){
		CloneCraftCraftingHandler.add(this);
	}

	@Override
	public void onCrafted(EntityPlayer player, ItemStack result, IInventory ic) {
		ItemStack[] items = getItems(ic);
		for(int a = 1; a < items.length; a++){
			ItemStack copy = items[a].copy();
			copy.stackSize = 1;
			copy.setItemDamage(0);
			new ItemData(items[a]).drain().save(copy);
			if(!player.inventory.addItemStackToInventory(copy)){
				player.dropPlayerItem(copy);
			}
		}
	}


	@Override
	public boolean isValidItem(ItemStack stack, IInventory ic) {
		ItemStack result = getResult(ic);
		if(result != null){
			return result.itemID == stack.itemID && result.getItemDamage() == stack.getItemDamage() && ItemStack.areItemStackTagsEqual(result, stack);
		}
		return false;
	}

	@Override
	public boolean matches(InventoryCrafting ic, World world) {
		return getItems(ic) != null;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting ic) {
		return getResult(ic);
	}
	
	public ItemStack getResult(IInventory ic){
		ItemStack[] allItems = getItems(ic);
		if(allItems != null){
			ItemStack needleOut = allItems[0].copy();
			ItemData needleData = new ItemData(needleOut);
			for(int a = 1; a < allItems.length; a++){
				ItemData itemData = new ItemData(allItems[a]);
				for(int b = 0; b < itemData.genes.length; b++){
					needleData.setGene(itemData.genes[b]);
				}
			}
			needleData.save();
			return needleOut;
		}
		return null;
	}


	public ItemStack[] getItems(IInventory ic){
		ItemStack needle = null;
		ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
		for(int a = 0; a < ic.getSizeInventory(); a++){
			ItemStack stack = ic.getStackInSlot(a);
			if(stack != null){
				if(stack.itemID == CloneCraft.needle.itemID){
					if(needle == null && stack.getItemDamage() == 2){
						needle = stack;
					}else{
						return null;
					}
				}else if(stack.itemID == CloneCraft.testTube.itemID){
					if(stack.getItemDamage() == 3 && new ItemData(stack).containsGenes()){
						stacks.add(stack);
					}else{
						return null;
					}
				}else{
					return null;
				}
			}
		}
		if(needle == null || stacks.isEmpty()){
			return null;
		}else{
			ItemStack[] stacksArray = new ItemStack[stacks.size()+1];
			stacksArray[0] = needle;
			for(int a = 0; a < stacks.size(); a++){
				stacksArray[1+a] = stacks.get(a);
			}
//			System.out.println("Return: " + stacksArray.length);
			return stacksArray;
		}
	}
	/**
	 * 
	 * @param ic
	 * @return Null if more than two needles are found, otherwise the found needle
	 *//*
	public ItemStack getDNANeedle(InventoryCrafting ic){

	}

	  *//**
	  * 
	  * @param ic
	  * @return All the test-tubes 
	  *//*
	public ItemStack[] getGeneTubes(InventoryCrafting ic){
		int size = ic.getSizeInventory();
		ArrayList<ItemStack> tubes = new ArrayList<ItemStack>();
		for(int a = 0; a < size; a++){
			ItemStack stack = ic.getStackInSlot(a);
			if(stack != null){
				if(stack.itemID == CloneCraft.testTube.itemID){
					if(new ItemData(stack).containsGenes()){
						tubes.add(stack);
					}else{
						return null;
					}
				}else{
					return null;
				}
			}
		}
		return tubes.size() == 0?null:tubes.toArray(new ItemStack[tubes.size()]);
	}*/

	@Override
	public int getRecipeSize() {
		return 0;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return null;
	}

}
